<?php

namespace App\Http\Resources\Root;

use App\Metadata\Versions\FileVersion;
use App\Metadata\Versions\GitHubVersion;
use App\Metadata\Versions\InstalledVersion;
use App\Models\Configs;
use Spatie\LaravelData\Data;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;

#[TypeScript()]
class VersionResource extends Data
{
	public ?string $version = null;
	public bool $is_new_release_available;
	public bool $is_git_update_available;

	public function __construct()
	{
		if (!Configs::getValueAsBool('hide_version_number')) {
			$this->version = resolve(InstalledVersion::class)->getVersion()->toString();
		}

		$fileVersion = resolve(FileVersion::class);
		$gitHubVersion = resolve(GitHubVersion::class);

		if (Configs::getValueAsBool('check_for_updates')) {
			// @codeCoverageIgnoreStart
			$fileVersion->hydrate();
			$gitHubVersion->hydrate();
			// @codeCoverageIgnoreEnd
		}

		$this->is_new_release_available = !$fileVersion->isUpToDate();
		$this->is_git_update_available = !$gitHubVersion->isUpToDate();
	}
}
